﻿
CREATE PROCEDURE [App].[NVCC_usp_GetNextOfKin]
	@sid int   --PatientSid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jon Duckart
--Object/SP Name        : [NVCC_usp_GetNextOfKin]
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-07-2016
--
--Purpose               : To retrieve a single patient NOK record for the NVCC app by SID.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

   /*
   SELECT  SPatientAddressSID as NextOfKindId
   , PatientSID
   , Sta3n as Station
   , AddressType
   , NameOfContact
   , StreetAddress1
   , StreetAddress2
   , City
   , State
   , Zip
   , Phone
   , PhoneWork
   FROM  CDWWork.SPatient.SPatientAddress
   WHERE PatientSID= @sid and OrdinalNumber=2;  --OrdinalNumber=2, Next Of Kin
   */

/* Revised on 10/26/2017 by Trinity Hall CDW Architect */

SELECT  SPatientAddressSID as NextOfKindId
   , a.PatientSID
   , a.Sta3n as Station
   , a.AddressType
   , a.NameOfContact
   , a.StreetAddress1
   , a.StreetAddress2
   , a.City
   , a.State
   , a.Zip
   , b.PhoneNumber as Phone
   , b.[WorkPhoneNumber] as  PhoneWork
   FROM  CDWWork.SPatient.SPatientAddress a 
   Left Join CDWWork.SPatient.SPatientPhone b on a.PatientSID = b.PatientSID and b.OrdinalNumber = 2
   WHERE a.PatientSID= @sid and a.OrdinalNumber=2;  --OrdinalNumber=2, Next Of Kin
END

